//Just put all three files into same directory and run it by initiating following command line "oplrun .\VFIGroupInSquare.mod .\VFIRobot1.dat"  
// Developed by Ayhan Demiriz

using CP;

int nTask=...;
int nLink=...;
range t = 1..nTask;
range myType=1..3;
int nbPerm = ...; 
range rPerm=1..nbPerm;
int packetsz=32;

int TaskCPU[t]=...; 

tuple link { 
  int a; 
  int b;
}
{link} Links= ...;
tuple linkcost { 
  int a; 
  int b;
  int c;
}
{linkcost} LinkCostData= ...;


int jobDur[t]=...;
int XYCost[rPerm][rPerm] = ...;
int LinkCost[Links] =[<k.a,k.b>:k.c  | k in LinkCostData ];


int SizeSquare = 8;
int NbSquares  = 2; 

range Squares = 1..NbSquares;
int Size[Squares] = ...;


dvar interval x[s in Squares]  in 0..SizeSquare  size Size[s]; 
dvar interval y[s in Squares]  in 0..SizeSquare  size Size[s];
dvar interval jobs[p in t];
dvar boolean CPUtype[p in rPerm][z in myType];
dexpr float compTime= (max(p in 1..nTask) endOf(jobs[p]));
dvar int perm[1..nbPerm] in rPerm;
dexpr int cost[k in Links] = (LinkCost[k]+3*ftoi(ceil(LinkCost[k]/(packetsz-1.0))))*XYCost[perm[TaskCPU[k.a]]][perm[TaskCPU[k.b]]];


cumulFunction rx = sum(s in Squares) pulse(x[s], sizeOf(x[s]));
cumulFunction ry = sum(s in Squares) pulse(y[s], sizeOf(y[s]));


execute {
  var f = cp.factory;
  cp.setSearchPhases(f.searchPhase(perm),   
		     f.searchPhase(y),f.searchPhase(x),f.searchPhase(jobs));
  cp.param.timeLimit=300;
  cp.param.Workers=8;
  cp.param.logPeriod = 100000;
  cp.param.LogVerbosity = "Terse";  		     
};

minimize compTime;


constraints {
   alwaysIn(rx,0,SizeSquare,0,SizeSquare);
   alwaysIn(ry,0,SizeSquare,0,SizeSquare);

   forall(ordered i, j in Squares)
     endOf(x[i]) <= startOf(x[j]) ||
     endOf(x[j]) <= startOf(x[i]) ||
     endOf(y[i]) <= startOf(y[j]) ||
     endOf(y[j]) <= startOf(y[i]);
 
   allDifferent(perm);
   
   forall(k in t)
     sizeOf(jobs[k])==ftoi(ceil(jobDur[k]*(CPUtype[perm[TaskCPU[k]]][1]*1.4+CPUtype[perm[TaskCPU[k]]][2]+CPUtype[perm[TaskCPU[k]]][3]*0.7)));
   
    forall(k in rPerm)
     (sum(i in myType) CPUtype[k][i])==1;
    forall(s in Squares ) 
      (sum (k in rPerm) CPUtype[k][s+1])==Size[s]*Size[s];
    forall(k in Links)
  		endBeforeStart(jobs[k.a], jobs[k.b],cost[k]);
    forall(k in rPerm,s in Squares )
     CPUtype[k][s+1]== ( (k%SizeSquare > startOf(x[s]) && (ceil(k/SizeSquare) > startOf(y[s])) && (k%SizeSquare <= endOf(x[s])) &&(ceil(k/SizeSquare) <= endOf(y[s]))));
       
};

 