/*********************************************
 * OPL 12.4 Model
 * Author: ademiriz
 * Creation Date: Apr 3, 2013 at 5:08:04 AM
 *********************************************/

int nbPerm = ...;
range r = 1..nbPerm;
int nTask=...;
int nLink=...;
range t = 1..nTask;
string dFile=...;
tuple link { 
  int a; 
  int b;
}
{link} Links= ...;

tuple linkcost { 
  int a; 
  int b;
  int c;
}
{linkcost} LinkCostData= ...;

int TaskCPU[t]=...;


int XYCost[r][r] = ...;
int LinkCost[Links] =[<k.a,k.b>:k.c  | k in LinkCostData ];


//int jobDur[t]=...;

execute {
      cplex.tilim=5000;
      cplex.threads=4;
     // cplex.logPeriod = 40000;
      //cplex.LogVerbosity = "Quiet";
}

tuple Comb {
link s;
{string} spath;
};

{Comb} Combination=...; 

int packetsz=8;


dvar int x[r][r] in 0..1;
//dvar interval jobs[p in 1..nTask] size jobDur[p];

dexpr int cost[k in Links] = sum(i in r, j in r) (LinkCost[k]+3*ftoi(ceil(LinkCost[k]/(packetsz-1.0))))*XYCost[i][TaskCPU[k.b]]*x[i][TaskCPU[k.a]]*x[j][TaskCPU[k.b]];

minimize sum(k in Links) cost[k];
//minimize max(p in 1..nTask) endOf(jobs[p]) + sum(k in Links) cost[k];
//minimize max(p in 1..nTask) endOf(jobs[p]);
subject to {

  forall (j in r) sum(i in r) x[i][j] == 1;
  forall (i in r) sum(j in r) x[i][j] == 1;
  forall (i in r) x[i][i] == 0;

};

execute DISPLAY {
writeln(" Maximum profit = " , cplex.getObjValue());
}