/*********************************************
 * OPL 6.3 Model
 * Author: Administrator
 * Creation Date: Mar 24, 2010 at 6:13:40 PM
 *********************************************/
int NbPoints = ...;
range Points = 1..NbPoints;
int NbClusters=...;
range Clusters=1..NbClusters;
int NbVars = ...;
range Vars = 1..NbVars;
int MinClusSize[Clusters];
float Distance[i in Points][j in Clusters]=0.0;
float ClusData[Points][Vars] = ...;
float ClusCenter[Clusters][Vars];
int initialClus[i in 1..NbClusters]=rand(NbPoints);
tuple association { 
  int frst; 
  int scnd; 
}
{association} pos=...;
{association} neg=...;

execute{
  for(var tr in Clusters) {
   MinClusSize[tr]=4;
}
  var totalD; 
  for(var r in Clusters) {
    for(var t=1;t<=r;t++){
    	if (initialClus[r]==initialClus[t]){
    		initialClus[t]=(initialClus[r]+2) % NbPoints;    	
    	}
     for( t=1;t<=NbVars;t++){
     	ClusCenter[r][t]=ClusData[initialClus[r]][t];
     }
    }
    
  }
  for( t=1;t<=NbPoints;t++){
  	for(r in Clusters){
  		totalD=0;
  		for(var k=1;k<=NbVars;k++){
  			totalD+=Opl.pow(ClusCenter[r][k]-ClusData[t][k],2.0);
  		}
  		Distance[t][r]=Opl.pow(totalD,0.5);
  	}  
  
  }
  
}

dvar boolean ClusAssign[Points][Clusters];


minimize
  sum( w in Clusters , s in Points ) 
   Distance[s][w]* ClusAssign[s][w];

subject to{
  forall( s in Points )
    ctEachPointAssigned2OneCluster:
      sum( w in  Clusters ) 
        ClusAssign[s][w] == 1;

}

{int} Pointsof[w in Clusters] = { s | s in Points : ClusAssign[s][w] == 1 };
execute DISPLAY_RESULTS{
 // writeln("Cluster Centers=",ClusCenter);
 // writeln("Distance=",Distance);
  writeln("Pointsof=",Pointsof);
}

main {
   var totalD; 
   thisOplModel.generate();
   var best;
   var curr = Infinity;
   var t;
   var r;
   var k;
   var count_csize;
   var tempDistance=new Array;

   var ClusOplModel = thisOplModel; 
   var vNbPoints=ClusOplModel.NbPoints;
   var vNbClusters=ClusOplModel.NbClusters; 
   var vNbVars=ClusOplModel.NbVars;
 
  while ( 1 ) {
    best = curr;

    if ( cplex.solve() ) {
      curr = cplex.getObjValue();
      writeln();
      writeln("OBJECTIVE: ",curr);   
    } 
    else {
      writeln("No solution!");
      ClusOplModel.end();
      break;
    }
    cplex.populate();
    ClusOplModel.postProcess();
    if ( best==curr ) {
    break;
    }
    //update cluster centers
    for(r=1;r<=ClusOplModel.NbClusters;r++){
        count_csize=0;
        for(k=1;k<=ClusOplModel.NbVars;k++){
        ClusOplModel.ClusCenter[r][k]=0.0;
        }
    	for( t=1;t<=ClusOplModel.NbPoints;t++){
         if (ClusOplModel.ClusAssign[t][r] == 1)
         	{count_csize++;
         	 for(k=1;k<=ClusOplModel.NbVars;k++){
             	ClusOplModel.ClusCenter[r][k]+=ClusOplModel.ClusData[t][k];
             }
         	}
     	}
     	for(k=1;k<=ClusOplModel.NbVars;k++){
        ClusOplModel.ClusCenter[r][k]/=(count_csize+0.0);
        }
     }
    //calculate new distances
    for( t=1;t<=ClusOplModel.NbPoints;t++){
  	for(r=1;r<=ClusOplModel.NbClusters;r++){
  		totalD=0.0;
  		for(k=1;k<=ClusOplModel.NbVars;k++){
  			totalD+=Opl.pow(ClusOplModel.ClusCenter[r][k]-ClusOplModel.ClusData[t][k],2.0);
  		}
  		totalD=Opl.pow(totalD,0.5);
  		ClusOplModel.Distance[t][r]=totalD;
  		cplex.setObjCoef(ClusOplModel.ClusAssign[t][r], totalD);
  	}  
     
  }
  

  0;
  
  }
}


