/*********************************************
 * OPL 6.3 Model
 * Author: ademiriz
 * Creation Date: Oct 3, 2011 at 9:30:31 PM
 *********************************************/
 using CP;

int nTask=...;
range t = 1..nTask;

tuple link { 
  int a; 
  int b;
}
{link} Links= ...;

int jobDur[t]=...;

execute {
      cp.param.timeLimit=1000;
      cp.param.Workers=4;
      cp.param.logPeriod = 40000;
      cp.param.LogVerbosity = "Quiet";    
}


 
tuple TransPacket {
  int id;    // Operation id 
  link jobId; // Job id 
  int pckt; //Packet id
  int pos;   // Position in job  
  string lnk;  // Machine
  int headyes; //
  int pt;   // Processing time
};

{TransPacket} Trans   = ...;


// Position of last operation of job j
int jlastid[j in Links] = max(o in Trans: o.jobId==j) o.id;
int jfirstid[j in Links] = min(o in Trans: o.jobId==j) o.id;
//int jlast[j in Links] = max(o in Trans: o.jobId==j) o.pos;
//int jfirst[j in Links] = min(o in Trans: o.jobId==j) o.pos;
//string firstlink[Links] = [o.jobId: o.lnk | o in Trans : o.id==jfirstid[o.jobId]] ;

{string} lnks={o.lnk | o in Trans};
dvar interval pckts  [md in Trans] size md.pt; 
dvar sequence translegs[l in lnks] in all(md in Trans: md.lnk == l) pckts[md];
dvar interval jobs[p in t] size jobDur[p];
minimize max(p in 1..nTask) endOf(jobs[p]);

subject to {

   forall(k in Links)
  	endBeforeStart(jobs[k.a], jobs[k.b]); 	
    
   forall(k in Links,o1 in Trans : o1.jobId==k && jfirstid[k]==o1.id)
		endBeforeStart(jobs[k.a], pckts[o1]); 
		
   forall(k in Links,o1 in Trans : o1.jobId==k && jlastid[k]==o1.id)
		endBeforeStart(pckts[o1],jobs[k.b]);
		
  // forall (l in Links, o1 in Trans, o2 in Trans: o1.jobId==l && o2.jobId==l && o1.pckt==o2.pckt && o2.pos==1+o1.pos)
   // endBeforeStart(pckts[o1],pckts[o2]); 
   forall (l in Links, o1 in Trans, o2 in Trans: o1.jobId==l && o2.jobId==l && o1.pckt==o2.pckt && o2.pos==1+o1.pos)
    endAtStart(pckts[o1],pckts[o2]);  	
				
   forall (l in Links, o1 in Trans, o2 in Trans: o1.jobId==l  && o2.jobId==l &&  o1.pckt+1==o2.pckt && o1.pos==o2.pos+1)
    endBeforeStart(pckts[o1],pckts[o2]);
   
   forall (l in Links, o1 in Trans, o2 in Trans: o1.jobId==l  && o2.jobId==l &&  o1.pckt==o2.pckt && o1.pos+3==o2.pos && o1.headyes==1 && o2.headyes==1)
    endBeforeStart(pckts[o1],pckts[o2]); 	
      
   forall (l in lnks)
     noOverlap(translegs[l]);
};


//execute {
//  for (var mt in Trans) {
//    if (pckts[mt].present)
 //     writeln("Operation " + mt.id + " on machine " + mt.lnk + " starting at " + pckts[mt].start);
 // }
//}
