/*********************************************
 * OPL 6.3 Model
 * Author: ademiriz
 * Creation Date: Oct 3, 2011 at 11:09:44 AM
 *********************************************/
using CP;

int nbPerm = ...;
range r = 1..nbPerm;
int nTask=...;
int nLink=...;
range t = 1..nTask;
int nRand=...;
range nR = 1..nRand;
tuple link { 
  int a; 
  int b;
}
{link} Links= ...;

tuple linkcost { 
  int a; 
  int b;
  int c;
}
{linkcost} LinkCostData= ...;

int TaskCPU[t]=...;
int rTaskCPU[nR][t]=...;


int XYCost[r][r] = ...;
int LinkCost[Links] =[<k.a,k.b>:k.c  | k in LinkCostData ];


execute {
      cp.param.timeLimit=300;
      cp.param.Workers=4;
      cp.param.logPeriod = 40000;
      cp.param.LogVerbosity = "Quiet";
}

tuple Comb {
link s;
{string} spath;
};

{Comb} Combination=...; 

int packetsz=64;


dvar int perm[1..nbPerm] in r;

dexpr int cost[k in Links] = (LinkCost[k]+3*ftoi(ceil(LinkCost[k]/(packetsz-1.0))))*XYCost[perm[TaskCPU[k.a]]][perm[TaskCPU[k.b]]];

minimize sum(k in Links) cost[k];

subject to {

  allDifferent(perm);
  

};

main {
 
  // thisOplModel.settings.mainEndEnabled = true;
   thisOplModel.generate();
   var myCPmodel=thisOplModel;
   var def = myCPmodel.modelDefinition;
   var data = myCPmodel.dataElements;
  
   for(var myloop in myCPmodel.nR) {
      for(var sss in myCPmodel.t){    
    	 data.TaskCPU[sss]=data.rTaskCPU[myloop][sss];
    	} 
    var newCP = new IloCP();
    var hop = new IloOplModel(def, newCP);
    
    hop.addDataSource(data);
    hop.generate();
    if( newCP.solve()){  
   
     var ofile = new IloOplOutputFile("BandwidthWormHoleSchedData.dat");
     
     ofile.writeln("SheetConnection sheet(\"Data20A.xls\");");
     ofile.writeln("nTask from SheetRead(sheet,\"nTask!A1\");");
     ofile.write("Links from SheetRead(sheet,\"LinkCost!A1:B");
     ofile.write(hop.nLink);
     ofile.write("\");\n");
     ofile.write("jobDur from SheetRead(sheet,\"JobDur!A1:A");
     ofile.write(hop.nTask);
     ofile.write("\");\n");   
     ofile.write("Trans={");
     
    var total=0;
    var ops=0;
    var pos=0;
    var pckt=0;
    for (var s in hop.Links){ 
       pos=-1;
       pckt=0;
       total+=hop.cost[s];
       for (var jj=0; jj < Opl.ftoi(Opl.ceil(hop.LinkCost[s]/(hop.packetsz-1.0))); jj++) {        
          for (var jjj in hop.Combination){        	 
        	 if(jjj.s.a==hop.TaskCPU[s.a]&& jjj.s.b==hop.TaskCPU[s.b]){
        	    var ss=jjj.spath;
        	   break;
        	  }
        	 }
          pos=-1;	 	        	                  
          pckt=pckt+1;
          for (var tjj in ss){       	   
       	     ops=ops+1;
       		 pos=pos+2;       		 
       		 ofile.write("<");
      		 ofile.write(ops);
      		 ofile.write(",");
      		 ofile.write("<");      		
      		 ofile.write(s.a);
      		 ofile.write(",");      		
      		 ofile.write(s.b);
      		 ofile.write(">");
      		 ofile.write(",");
      		 ofile.write(pckt);
      		 ofile.write(",");
      		 ofile.write(pos);
      		 ofile.write(",\"");
      		 ofile.write(tjj);      		 
      		 ofile.write("\",");
      		 if (hop.perm[hop.TaskCPU[s.a]]==hop.perm[hop.TaskCPU[s.b]]){      		
      		 ofile.write("1,0");
      		 ofile.write(">");                   		 
     		 ofile.write(","); 
     		 ofile.write("\n"); 
      		 }
      		 else {
      		 	 ofile.write("1,3>,\n");
      		 	 ops=ops+1;
       		 	 pos=pos+1; 
       		 	 ofile.write("<");
	      		 ofile.write(ops);
	      		 ofile.write(",");
	      		 ofile.write("<");      		
	      		 ofile.write(s.a);
	      		 ofile.write(",");      		
	      		 ofile.write(s.b);
	      		 ofile.write(">");
	      		 ofile.write(",");
	      		 ofile.write(pckt);
	      		 ofile.write(",");
	      		 ofile.write(pos);
	      		 ofile.write(",\"");
	      		 ofile.write(tjj);      		 
	      		 ofile.write("\",0,");
      		 
      		    if (jj+1==Opl.ftoi(Opl.ceil(hop.LinkCost[s]/(hop.packetsz-1.0)))){
      		    ofile.write(Opl.ftoi(hop.LinkCost[s]%(hop.packetsz-1.0)));
      		    }
      		    else{
      		 	ofile.write(hop.packetsz-1);
      		   }
      		 ofile.write(">");                   		 
     		 ofile.write(","); 
     		 ofile.write("\n"); 
      		 }      		       		     				 
            }
         }
      }
    ofile.write("};"); 
    ofile.close(); 

     var source2 = new IloOplModelSource("BandwidthWormHoleSchedule.mod");
     var def2 = new IloOplModelDefinition(source2);
     var subCP = new IloCP();
     var submodel = new IloOplModel(def2, subCP);
     var submodeldata = new IloOplDataSource("BandwidthWormHoleSchedData.dat");
    
     submodel.addDataSource(submodeldata);
  
     submodel.generate();
     
     if( subCP.solve()){
     
  
     	var packet=0;
        var tlnk;
        var stime=0;
        var etime=0;
        var cpckt=0.0;
        var sotime=0;
        for (var mt in submodel.Trans) {
        //  if (submodel.pckts[mt].present)
     	//     writeln("Operation " + mt.id + " on machine " + mt.lnk + " starting at " + submodel.pckts[mt].start+" ending at " + submodel.pckts[mt].end);
          
       	  if (packet==0){
        	  	packet=mt.pckt;
        	  	tlnk=mt.jobId;
        	  	stime=submodel.pckts[mt].start;
        	    };
        	     
         if (packet!=mt.pckt || tlnk!=mt.jobId) {
        	//  	writeln(etime-stime);
        	  	sotime+=(etime-stime);
        	  	cpckt+=1.0;
        	  	packet=mt.pckt;
        	  	tlnk=mt.jobId;
        	  	stime=submodel.pckts[mt].start;
        	  };
        	  etime=submodel.pckts[mt].end;
        	  
        	 }
       }
        sotime+=(etime-stime);
        cpckt+=1.0;
        writeln("\"Random Realization "+myloop+"\","+total+","+subCP.getObjValue()+","+sotime/cpckt+","+ subCP.info.NumberOfSolutions);
       
      }
      else{
     	 writeln("\"Random Realization "+myloop+"\", , , ");
      }
  
  
  }
  
 // submodeldata.end();
 // def2.end();
 // source2.end();
 // subCP.end();
 // newCP.end();
 // hop.end();
  //submodel.end()
  
 // data.end();
//  def.end();
 // myCPmodel.end();  
}